function playAudio() {
    var audio = document.getElementById("meuAudio");
    if (audio) {
        // console.log('Elemento de áudio encontrado, tentando reproduzir');
        audio.play().catch(function(error) {
            console.error('Erro ao reproduzir áudio:', error);
        });
    } else {
        console.error('Elemento de áudio não encontrado');
    }
}



      

// FunÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o para definir um cookie
function setCookie(cname, cvalue, exdays) {
    const d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    const expires = `expires=${d.toUTCString()}`;
    document.cookie = `${cname}=${cvalue}; ${expires}; path=/`;
}

// FunÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o para obter o valor de um cookie
function getCookie(cname) {
    const name = `${cname}=`;
    const decodedCookie = decodeURIComponent(document.cookie);
    const ca = decodedCookie.split(';');
    for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) === ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) === 0) {
            return c.substring(name.length, c.length);
        }
    }
    return '';
}

let valor = parseFloat(getCookie('valor')) || 100.00;
const valorSpan = document.getElementById('valor');
const valorSpanSaque = document.getElementById('valor-saque');
const valorSpanMoney = document.getElementById('valor-money');

document.addEventListener('DOMContentLoaded', () => {
    const valorSaldo = getCookie('valorSaldo');
    if (valorSaldo) {
        valor = parseFloat(valorSaldo);
        atualizarValor();
    }
})

// Array com os valores desejados
const valoresDesejados = [33, 34, 47, 43, 52, 32, 32, 27, 30, 43];

// Variável para controle do botão ativo
let activeButton = null;

function atualizarValor() {
    // console.log('atualizarValor chamada, valor atual:', valor);
    
    // Busque os elementos no momento da atualização
    const elementoValor = document.getElementById('valor');
    const elementoValorSaque = document.getElementById('valor-saque');
    const elementoValorMoney = document.getElementById('valor-money');

    // Se nenhum destino existir, não há o que atualizar (evita erros em console durante a inicialização)
    if (!elementoValor && !elementoValorSaque && !elementoValorMoney) {
        return;
    }

    const valorFormatado = formatarValor(valor);
    // console.log('Valor formatado:', valorFormatado);

    if (elementoValor) {
        elementoValor.textContent = valorFormatado;
        // console.log('Elemento valor atualizado para:', valorFormatado);
    }
    if (elementoValorSaque) {
        elementoValorSaque.textContent = valorFormatado;
        // console.log('Elemento valor-saque atualizado para:', valorFormatado);
    }
    if (elementoValorMoney) {
        elementoValorMoney.textContent = valorFormatado;
        // console.log('Elemento valor-money atualizado para:', valorFormatado);
    }

    setCookie('valor', valor.toFixed(2), 365);
}

// Inicializador robusto que só chama atualizarValor quando os elementos estiverem disponíveis
function initAtualizacaoValor() {
    const ensureAndUpdate = () => {
        const hasAny =
            document.getElementById('valor') ||
            document.getElementById('valor-saque') ||
            document.getElementById('valor-money');

        if (!hasAny) {
            // Tenta novamente em curto intervalo para contornar variações de carregamento em produção
            setTimeout(ensureAndUpdate, 150);
            return;
        }
        atualizarValor();
    };

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', ensureAndUpdate, { once: true });
    } else {
        ensureAndUpdate();
    }
}
initAtualizacaoValor(); // Atualiza o valor inicial na caixa de valor

// FunÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o para aumentar o valor
function aumentarValor() {
    console.log('aumentarValor chamada, valores restantes:', valoresDesejados.length, 'valor atual:', valor);
    // Se ainda houver valores no array
    if (valoresDesejados.length > 0) {
        // Retira o próximo valor do array
        const valorIncremento = valoresDesejados.shift();
        // console.log('Incrementando valor em:', valorIncremento);

        // Adiciona o valor ao total
        const valorAnterior = valor;
        valor += valorIncremento;
        // console.log('Valor atualizado de', valorAnterior, 'para', valor);

        // Atualiza e verifica o valor
        atualizarValor();
        verificarValor();
    } else {
        // console.log('Não há mais valores para adicionar');
    }
}  





function mostrarPagina(pagina) {
  // Obter elementos diretamente para garantir que existam
  const inicioDiv = document.getElementById('inicio');
  const saqueDiv = document.getElementById('saque');
  const loginDiv = document.getElementById('login');
  const bonusDiv = document.getElementById('bonus');
  
  // Esconder todas as páginas primeiro
  if (inicioDiv) inicioDiv.style.display = 'none';
  if (saqueDiv) saqueDiv.style.display = 'none';
  if (loginDiv) loginDiv.style.display = 'none';
  if (bonusDiv) bonusDiv.style.display = 'none';
  
  // Mostrar apenas a página solicitada
  if (pagina === 'inicio' && inicioDiv) {
    inicioDiv.style.display = 'block';
    // Garante que o valor seja exibido/atualizado ao entrar em "inicio"
    atualizarValor();
  } else if (pagina === 'saque' && saqueDiv) {
    saqueDiv.style.display = 'block';
  } else if (pagina === 'login' && loginDiv) {
    loginDiv.style.display = 'block';
  } else if (pagina === 'bonus' && bonusDiv) {
    bonusDiv.style.display = 'block';
  }
}

function trocarDiv(esconderId, mostrarId) {
  // console.log('trocarDiv chamada - esconder:', esconderId, 'mostrar:', mostrarId);
  const elementoEsconder = document.getElementById(esconderId);
  const elementoMostrar = document.getElementById(mostrarId);
  
  if (elementoEsconder) {
    elementoEsconder.style.display = 'none';
    // console.log('Elemento', esconderId, 'ocultado');
  } else {
    console.error('Elemento para esconder não encontrado:', esconderId);
  }
  
  if (elementoMostrar) {
    elementoMostrar.style.display = 'block';
    // console.log('Elemento', mostrarId, 'exibido');
  } else {
    console.error('Elemento para mostrar não encontrado:', mostrarId);
  }
}

// Remova chamadas diretas duplicadas de atualizarValor() aqui e use o inicializador:
initAtualizacaoValor(); // Inicializa atualização apenas quando DOM/elementos estiverem prontos




//--------------------------------- Ad 1 ---------------------------------


function showPopupB1() {
    // console.log('showPopupB1 chamada');
    const button = document.getElementById('B1');
    const popup = document.getElementById('popupB1');
    
    if (button) {
        button.disabled = true;
        // console.log('Botão B1 desabilitado');
    } else {
        console.error('Botão B1 não encontrado');
    }
    
    if (popup) {
        popup.style.display = 'block';
        // console.log('Popup B1 exibido');
    } else {
        console.error('Popup B1 não encontrado');
    }
}

function closePopupB1() {
    // console.log('closePopupB1 chamada');
    const popup = document.getElementById('popupB1');
    const button = document.getElementById('B1');
    
    if (popup) {
        popup.style.display = 'none';
        // console.log('Popup B1 ocultado');
    } else {
        console.error('Popup B1 não encontrado');
    }
    
    if (button) {
        button.disabled = true;
        // console.log('Botão B1 mantido desabilitado');
    }
}   

// Carregando B1
function showLoadingB1() {
    // console.log('showLoadingB1 chamada');
    var button = document.getElementById("B1");
    if (button) {
        // console.log('Botão B1 encontrado, iniciando sequência');
        showPopupB1();
        playAudio();
        // Simulando um atraso de 4 segundos
        setTimeout(function () {
            // console.log('Timeout de 4s executado para B1');
            closePopupB1();
            aumentarValor();
            trocarDiv('ad1', 'ad2');
        }, 4000);
    } else {
        console.error('Botão B1 não encontrado em showLoadingB1');
    }
}


//--------------------------------- Ad 2 ---------------------------------


function showPopupB2() {
    document.getElementById('popupB2').style.display = 'block';
    document.getElementById('B2').disabled = true;
}

function closePopupB2() {
    document.getElementById('popupB2').style.display = 'none';
    document.getElementById('B2').disabled = true;
}   

// Carregando B2
    function showLoadingB2() {
        var button = document.getElementById("B2");
            showPopupB2();
            playAudio();
            // Simulando um atraso de 3 segundos para o showPopup2()
            setTimeout(function () {
                closePopupB2();
                aumentarValor();
                trocarDiv('ad2', 'ad3');
            }, 4000); // 3 segundos
        }

    
//--------------------------------- Ad 3 ---------------------------------


function showPopupB3() {
    document.getElementById('popupB3').style.display = 'block';
    document.getElementById('B3').disabled = true;
}

function closePopupB3() {
    document.getElementById('popupB3').style.display = 'none';
    document.getElementById('B3').disabled = true;
}   


    function showLoadingB3() {
        var button = document.getElementById("B3");
            showPopupB3();
            playAudio();
            setTimeout(function () {
                closePopupB3();
                aumentarValor();
                trocarDiv('ad3', 'ad4');
            }, 4000); 
        }


//--------------------------------- Ad 4 ---------------------------------


function showPopupB4() {
    document.getElementById('popupB4').style.display = 'block';
    document.getElementById('B4').disabled = true;
}

function closePopupB4() {
    document.getElementById('popupB4').style.display = 'none';
    document.getElementById('B4').disabled = true;
}   


    function showLoadingB4() {
        var button = document.getElementById("B4");
            showPopupB4();
            playAudio();
            setTimeout(function () {
                closePopupB4();
                aumentarValor();
                trocarDiv('ad4', 'ad5');
            }, 4000); 
        }


//--------------------------------- Ad 5 ---------------------------------


function showPopupB5() {
    document.getElementById('popupB5').style.display = 'block';
    document.getElementById('B5').disabled = true;
}

function closePopupB5() {
    document.getElementById('popupB5').style.display = 'none';
    document.getElementById('B5').disabled = true;
}   


    function showLoadingB5() {
        var button = document.getElementById("B5");
            showPopupB5();
            playAudio();
            setTimeout(function () {
                closePopupB5();
                aumentarValor();
                trocarDiv('ad5', 'ad6');
            }, 4000);
        }

    
//--------------------------------- Ad 6 ---------------------------------


function showPopupB6() {
    document.getElementById('popupB6').style.display = 'block';
    document.getElementById('B6').disabled = true;
}

function closePopupB6() {
    document.getElementById('popupB6').style.display = 'none';
    document.getElementById('B6').disabled = true;
}   


    function showLoadingB6() {
        var button = document.getElementById("B6");
            showPopupB6();
            playAudio();
            setTimeout(function () {
                closePopupB6();
                aumentarValor();
                trocarDiv('ad6', 'ad7');
            }, 4000);
        }

//--------------------------------- Ad 7 ---------------------------------


function showPopupB7() {
    document.getElementById('popupB7').style.display = 'block';
    document.getElementById('B7').disabled = true;
}

function closePopupB7() {
    document.getElementById('popupB7').style.display = 'none';
    document.getElementById('B7').disabled = true;
}   


    function showLoadingB7() {
        var button = document.getElementById("B7");
            showPopupB7();
            playAudio();
            setTimeout(function () {
                closePopupB7();
                aumentarValor();
                trocarDiv('ad7', 'ad8');
            }, 4000);
        }


//--------------------------------- Ad 8 ---------------------------------


function showPopupB8() {
    document.getElementById('popupB8').style.display = 'block';
    document.getElementById('B8').disabled = true;
}

function closePopupB8() {
    document.getElementById('popupB8').style.display = 'none';
    document.getElementById('B8').disabled = true;
}   


    function showLoadingB8() {
        var button = document.getElementById("B8");
            showPopupB8();
            playAudio();
            setTimeout(function () {
                closePopupB8();
                aumentarValor();
                trocarDiv('ad8', 'ad9');
            }, 4000);
        }


//--------------------------------- Ad 9 ---------------------------------

function showLoadingB9() {
    var button = document.getElementById("B9");
        document.getElementById('popupB9').style.display = 'block';
        playAudio();
        setTimeout(function () {
            document.getElementById('popupB9').style.display = 'none';
            aumentarValor();
            aumentarValor();
            trocarDiv('ad9', 'ad10');
        }, 4000);
    }



//--------------------------------- Ad 10 ---------------------------------


    function showLoadingB10() {
        var button = document.getElementById("B10");
            document.getElementById('popupB10').style.display = 'block';
            playAudio();
            setTimeout(function () {
                document.getElementById('popupB10').style.display = 'none';
                aumentarValor();
                trocarDiv('ad10', 'ad11');
            }, 4000);
        }


//---------------------------- BotÃƒÆ'Ã‚Â£o chave PIX ---------------------------

function toggleButton(buttonNumber) {
  const buttons = document.querySelectorAll('.square-button');
  const chavePixInput = document.getElementById('chave-pix');

  if (activeButton !== null) {
   buttons[activeButton - 1].classList.remove('active');
  }

  if (activeButton === buttonNumber) {
    activeButton = null;
    // Remove máscara quando nenhum botão está ativo
    chavePixInput.placeholder = 'Digite sua chave PIX aqui';
    chavePixInput.value = '';
    chavePixInput.removeEventListener('input', aplicarMascaraCPF);
    chavePixInput.removeEventListener('input', aplicarMascaraTelefone);
    chavePixInput.removeEventListener('input', aplicarMascaraEmail);
    chavePixInput.removeEventListener('input', aplicarMascaraChaveAleatoria);
  } else {
    buttons[buttonNumber - 1].classList.add('active');
    activeButton = buttonNumber;
    
    // Limpa o input e remove listeners anteriores
    chavePixInput.value = '';
    chavePixInput.removeEventListener('input', aplicarMascaraCPF);
    chavePixInput.removeEventListener('input', aplicarMascaraTelefone);
    chavePixInput.removeEventListener('input', aplicarMascaraEmail);
    chavePixInput.removeEventListener('input', aplicarMascaraChaveAleatoria);
    
    // Aplica máscara baseada no botão selecionado
    switch(buttonNumber) {
      case 1: // CPF
        chavePixInput.placeholder = 'Digite seu CPF (000.000.000-00)';
        chavePixInput.addEventListener('input', aplicarMascaraCPF);
        break;
      case 2: // Telefone
        chavePixInput.placeholder = 'Digite seu telefone (11) 99999-9999';
        chavePixInput.addEventListener('input', aplicarMascaraTelefone);
        break;
      case 3: // Email
        chavePixInput.placeholder = 'Digite seu e-mail';
        chavePixInput.addEventListener('input', aplicarMascaraEmail);
        break;
      case 4: // Chave aleatória
        chavePixInput.placeholder = 'Digite sua chave aleatória';
        chavePixInput.addEventListener('input', aplicarMascaraChaveAleatoria);
        break;
    }
  }
} 

// Funções de máscara para chave PIX
function aplicarMascaraCPF(event) {
  let valor = event.target.value.replace(/\D/g, '');
  
  // Limita a 11 dígitos (CPF)
  if (valor.length > 11) {
    valor = valor.substring(0, 11);
  }
  
  if (valor.length <= 11) {
    valor = valor.replace(/(\d{3})(\d)/, '$1.$2');
    valor = valor.replace(/(\d{3})(\d)/, '$1.$2');
    valor = valor.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
  }

  event.target.value = valor;
}

function aplicarMascaraTelefone(event) {
  let valor = event.target.value.replace(/\D/g, '');
  
  // Limita a 11 dígitos (telefone celular)
  if (valor.length > 11) {
    valor = valor.substring(0, 11);
  }
  
  if (valor.length <= 11) {
    valor = valor.replace(/(\d{2})(\d)/, '($1) $2');
    valor = valor.replace(/(\d{5})(\d)/, '$1-$2');
  }
  
  event.target.value = valor;
}

function aplicarMascaraEmail(event) {
  // Para email, apenas remove espaços e converte para minúsculas
  let valor = event.target.value.replace(/\s/g, '').toLowerCase();
  
  // Limita a 254 caracteres (limite padrão de email)
  if (valor.length > 254) {
    valor = valor.substring(0, 254);
  }
  
  event.target.value = valor;
}

function aplicarMascaraChaveAleatoria(event) {
  // Para chave aleatória, permite apenas caracteres alfanuméricos e hífen
  let valor = event.target.value.replace(/[^a-zA-Z0-9-]/g, '');
  
  // Limita a 32 caracteres (chave PIX aleatória)
  if (valor.length > 32) {
    valor = valor.substring(0, 32);
  }
  
  event.target.value = valor;
}

// Popup SAQUE

function showPopup() {
  document.getElementById('popup').style.display = 'block';
}

function showLoadingButton() {
  var button = document.getElementById("realizar-saque");
  button.disabled = true; // Desabilitar o botÃƒÆ’Ã‚Â£o enquanto a animaÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o ocorre

  button.innerHTML = '<span class="loading-spinner"></span> Carregando...';

  // Simulando um atraso de 3 segundos para a animaÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o
  setTimeout(function() {
    // Redirecionar apÃƒÆ’Ã‚Â³s o atraso
    showPopup();
  }, 2000); // 2 segundos
}



function closePopup() {
  document.getElementById('popup').style.display = 'none';
}  




// Popup LIMITE DIÃƒÆ’Ã‚ÂRIO

function showPopupL() {
  document.getElementById('popupL').style.display = 'block';
}

function closePopupL() {
  document.getElementById('popupL').style.display = 'none';
}  



// POPUP Limite diÃƒÆ’Ã‚Â¡rio quando bate X valor
function verificarValor() {
    if (valor >= 470 && valor < 475) {
        // Popup para valor >= 1362.60 e < 2725.20
        showPopupL();
    } else if (valor >= 940 && valor < 950) {
        // Popup para valor >= 2725.20 e < 4087.8
        showPopupL();
    } else if (valor >= 1400) {
        // Popup para valor >= 4087.8
        showPopupL();
    }
    
}




function fecharPopupEAgendarReaparecimento() {
    var popupButtonContainer = document.querySelector(".popup-buttonL-container");
    popupButtonContainer.style.display = "none"; // Oculta o botÃƒÆ’Ã‚Â£o

    // Define um temporizador para mostrar o botÃƒÆ’Ã‚Â£o apÃƒÆ’Ã‚Â³s 10 segundos
    setTimeout(function() {
        popupButtonContainer.style.display = "block";
    }, 86400000); // 24 horas

    // Aqui vocÃƒÆ’Ã‚Âª tambÃƒÆ’Ã‚Â©m deve adicionar a funÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o para fechar o popup
    closePopupL();
}

// Chama a funÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o para mostrar o botÃƒÆ’Ã‚Â£o apÃƒÆ’Ã‚Â³s 10 segundos (10000 milissegundos)
setTimeout(function() {
    var botaoContainer = document.querySelector(".popup-buttonL-container");
    botaoContainer.style.display = "block";
}, 86400000); // 24 horas


// Script botÃƒÆ’Ã‚Â£o login
function showLoading() {
  var button = document.getElementById("prosseguir-button");
  button.disabled = true; // Desabilitar o botÃƒÆ’Ã‚Â£o enquanto a animaÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o ocorre

  button.innerHTML = '<span class="loading-spinner"></span> Carregando...';

  // Simulando um atraso de 3 segundos para a animaÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o
  setTimeout(function() {
    // Redirecionar apÃƒÆ’Ã‚Â³s o atraso
    mostrarPagina('inicio');
  }, 2000); // 2 segundos
}




function formatarValor(input) {
  // Verifica se input é um objeto com propriedade value ou um valor direto
  let valorString;
  
  if (typeof input === 'object' && input !== null && 'value' in input) {
    valorString = input.value || '';
  } else if (typeof input === 'number') {
    valorString = input.toFixed(2);
  } else if (typeof input === 'string') {
    valorString = input;
  } else {
    valorString = '';
  }
  
  // Se for um input DOM, formatar para entrada de usuário
  if (typeof input === 'object' && input !== null && 'value' in input) {
    // Se for o input de quantia, apenas formatar como dinheiro para exibição
    if (input.id === 'quantia') {
      // Remove todos os caracteres não numéricos
      var valor = valorString.replace(/[^0-9]/g, '');
      
      if (valor.length === 0) {
        input.value = '';
        return;
      }
      
      // Converte para número e formata como moeda
      var numero = parseFloat(valor) / 100;
      input.value = 'R$ ' + numero.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
      
      // Chama validação dos campos sem validar o valor específico
      validarCamposSaque();
    } else {
      // Para outros inputs, manter formatação original
      var valor = valorString.replace(/[^0-9]/g, '');
      var parteInteira = valor.slice(0, -2);
      var centavos = valor.slice(-2);
      input.value = parteInteira + '.' + centavos;
    }
  } else {
    // Para formatação de exibição (números)
    if (typeof input === 'number') {
      return 'R$ ' + input.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    } else {
      const numero = parseFloat(valorString) || 0;
      return 'R$ ' + numero.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    }
  }
}

// Função validarValorSaque removida - input quantia agora é apenas para exibição

// Função para validar os campos de saque e controlar o botão
function validarCamposSaque() {
  const chavePix = document.getElementById('chave-pix');
  const quantia = document.getElementById('quantia');
  const botaoSaque = document.querySelector('.desbloquear-button[onclick="showPopup()"]');
  
  if (!chavePix || !quantia || !botaoSaque) {
    console.error('Elementos não encontrados para validação');
    return;
  }
  
  const chavePreenchida = chavePix.value.trim().length > 0;
  const quantiaPreenchida = quantia.value.trim().length > 0;
  
  // Verifica se ambos os campos estão preenchidos (quantia agora é apenas exibição)
  const camposValidos = chavePreenchida && quantiaPreenchida;
  
  if (camposValidos) {
    botaoSaque.disabled = false;
    botaoSaque.style.opacity = '1';
    botaoSaque.style.cursor = 'pointer';
  } else {
    botaoSaque.disabled = true;
    botaoSaque.style.opacity = '0.5';
    botaoSaque.style.cursor = 'not-allowed';
  }
}

// Adiciona event listeners para validação em tempo real
document.addEventListener('DOMContentLoaded', function() {
  const chavePix = document.getElementById('chave-pix');
  const quantia = document.getElementById('quantia');
  const botaoSaque = document.querySelector('.desbloquear-button[onclick="showPopup()"]');
  
  if (chavePix) {
    chavePix.addEventListener('input', validarCamposSaque);
  }
  
  if (quantia) {
    quantia.addEventListener('input', function() {
      formatarValor(this);
    });
  }
});

function validateName() {
    const nome = document.getElementById('nome').value.trim();
    const button = document.getElementById('prosseguir-button');
    
    if (nome.length >= 2) {
        button.style.opacity = '1';
        button.disabled = false;
    } else {
        button.style.opacity = '0.5';
        button.disabled = true;
    }
}

function verificarCampos(e) {
    e.preventDefault();
    var nomeCompleto = document.getElementById('nome').value;

    if (nomeCompleto.trim() === '') {
        alert('Por favor, insira seu nome.');
    } else {
        // Se o campo estiver preenchido, redireciona para a prÃƒÆ’Ã‚Â³xima pÃƒÆ’Ã‚Â¡gina
        showLoading();
    }

    // ObtÃ©m o primeiro nome
  var primeiroNome = nomeCompleto.split(' ')[0];

  // Atualiza o conteÃºdo do parÃ¡grafo com o id 'saudacao'
  var saudacaoElemento = document.getElementById('saudacao');
  saudacaoElemento.textContent = 'Bem-vindo(a) ' + primeiroNome + '!';
}


function showPopupInicio() {
    document.getElementById('popupinicio').style.display = 'block';
  }

function closePopupInicio() {
    document.getElementById('popupinicio').style.display = 'none';
}

function in1() {
    closePopupInicio();
    showPopupInicio2();

        // Agendar a exibiÃƒÆ’Ã‚Â§ÃƒÆ’Ã‚Â£o do prÃƒÆ’Ã‚Â³ximo apÃƒÆ’Ã‚Â³s 5 segundos
        setTimeout(function() {
            closePopupInicio2();
            showPopupInicio3();
        }, 10000);
}    









function showPopupVideo() {
    document.getElementById('popupvideo').style.display = 'block';
  }

function closePopupVideo() {
    document.getElementById('popupvideo').style.display = 'none';
}

function video() {
    closePopup();
    showPopupVideo();
}   




      
function toggleAnswer(question) {
    const answer = question.nextElementSibling;
    answer.classList.toggle("active");
  
    const allQuestions = document.querySelectorAll(".question");
    allQuestions.forEach((otherQuestion) => {
      if (otherQuestion !== question) {
        otherQuestion.nextElementSibling.classList.remove("active");
      }
    });
  }
  
  
  
  // ----------------- TESTE ANUNCIO 1 -----------------

  document.addEventListener('DOMContentLoaded', function () {
    const containers = document.querySelectorAll('.rating-container');
  
    containers.forEach(function (container) {
      const buttons = container.querySelectorAll('.rating-button');
  
      buttons.forEach(function (button) {
        button.addEventListener('click', function () {
          // Remove a classe 'active' apenas do conjunto de botÃƒÆ’Ã‚Âµes dentro do mesmo container
          buttons.forEach(function (btn) {
            btn.classList.remove('active');
          });
  
          // Adiciona a classe 'active' apenas ao botÃƒÆ’Ã‚Â£o clicado
          button.classList.add('active');
        });
      });
    });
  });
  
  

  // function toggleCard(clickedElement) {
//     const allCards = document.querySelectorAll('.card__grade');
//     allCards.forEach(card => {
//         card.classList.remove('active');
//     });

//     clickedElement.classList.add('active');
// }

function toggleCard(clickedElement) {
    const allCards = document.querySelectorAll('.card__grade');
    
    allCards.forEach(card => {
        card.classList.remove('active');
    });

    // Adicione um switch para lidar com diferentes aÃƒÂ§ÃƒÂµes
    switch (clickedElement.id) {
        case 'card__grade1':
            updateStars('star1', 'fa-solid fa-star active', '#ffd700');
            updateStars('star2', 'fa-regular fa-star', '#7e7e7e');
            updateStars('star3', 'fa-regular fa-star', '#7e7e7e');
            updateStars('star4', 'fa-regular fa-star', '#7e7e7e');
            updateStars('star5', 'fa-regular fa-star', '#7e7e7e');
            break;
        case 'card__grade2':
            updateStars('star1', 'fa-solid fa-star active', '#ffd700');
            updateStars('star2', 'fa-solid fa-star active', '#ffd700');
            updateStars('star3', 'fa-regular fa-star', '#7e7e7e');
            updateStars('star4', 'fa-regular fa-star', '#7e7e7e');
            updateStars('star5', 'fa-regular fa-star', '#7e7e7e');
            break;
        case 'card__grade3':
            updateStars('star1', 'fa-solid fa-star active', '#ffd700');
            updateStars('star2', 'fa-solid fa-star active', '#ffd700');
            updateStars('star3', 'fa-solid fa-star active', '#ffd700');
            updateStars('star4', 'fa-regular fa-star', '#7e7e7e');
            updateStars('star5', 'fa-regular fa-star', '#7e7e7e');
            break;
        case 'card__grade4':
            updateStars('star1', 'fa-solid fa-star active', '#ffd700');
            updateStars('star2', 'fa-solid fa-star active', '#ffd700');
            updateStars('star3', 'fa-solid fa-star active', '#ffd700');
            updateStars('star4', 'fa-solid fa-star active', '#ffd700');
            updateStars('star5', 'fa-regular fa-star', '#7e7e7e');
            break;
        case 'card__grade5':
            updateStars('star1', 'fa-solid fa-star active', '#ffd700');
            updateStars('star2', 'fa-solid fa-star active', '#ffd700');
            updateStars('star3', 'fa-solid fa-star active', '#ffd700');
            updateStars('star4', 'fa-solid fa-star active', '#ffd700');
            updateStars('star5', 'fa-solid fa-star active', '#ffd700');
            break;
        // Adicione mais casos conforme necessÃƒÂ¡rio
        default:
            // AÃƒÂ§ÃƒÂ£o padrÃƒÂ£o, se nenhum caso corresponder
            // console.log("Nenhum caso correspondente");
    }
}

function updateStars(elementId, className, color) {
    const starElement = document.getElementById(elementId);
    if (starElement) {
        starElement.className = className;
        starElement.style.color = color; // Adiciona a cor amarela
    } else {
        console.error("Elemento nÃƒÂ£o encontrado com ID: " + elementId);
    }
}

// Adicione um evento de clique aos elementos que deseja controlar
const cards = document.querySelectorAll('.card__grade');

cards.forEach(card => {
    card.addEventListener('click', function() {
        toggleCard(this); // "this" se refere ao elemento clicado
    });
});


